export interface AIPhrase {
  phrase: string;
  category: 'common' | 'formal' | 'technical' | 'creative';
}

export interface DetectedPhrase {
  phrase: string;
  index: number;
  category: string;
}

export interface AnalysisResult {
  text: string;
  detectedPhrases: DetectedPhrase[];
  statistics: {
    wordCount: number;
    phraseCount: number;
    phraseDensity: number;
    uniquePhraseCount: number;
    uniquePhraseRatio: number;
  };
}