import React, { ReactNode } from 'react';
import { GithubIcon, MoonIcon, SunIcon } from 'lucide-react';
import { useDarkMode } from '../hooks/useDarkMode';

interface LayoutProps {
  children: ReactNode;
}

export const Layout: React.FC<LayoutProps> = ({ children }) => {
  const { isDarkMode, toggleDarkMode } = useDarkMode();

  return (
    <div className={`min-h-screen ${isDarkMode ? 'dark bg-gray-900' : 'bg-gray-50'}`}>
      <header className="sticky top-0 z-10 border-b bg-white/80 backdrop-blur-sm dark:border-gray-800 dark:bg-gray-900/80">
        <div className="mx-auto flex max-w-7xl items-center justify-between p-4">
          <div className="flex items-center gap-2">
            <span className="text-xl font-bold text-blue-600 dark:text-blue-400">AI Phrase Detector</span>
          </div>
          <div className="flex items-center gap-4">
            <a 
              href="https://github.com" 
              target="_blank" 
              rel="noopener noreferrer"
              className="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200"
            >
              <GithubIcon size={20} />
            </a>
            <button
              onClick={toggleDarkMode}
              className="rounded-full p-1 text-gray-500 hover:bg-gray-100 hover:text-gray-700 dark:text-gray-400 dark:hover:bg-gray-800 dark:hover:text-gray-200"
            >
              {isDarkMode ? <SunIcon size={20} /> : <MoonIcon size={20} />}
            </button>
          </div>
        </div>
      </header>

      {/* Top Banner Ad */}
      <div className="mx-auto max-w-7xl p-4">
        <div className="rounded-lg bg-gray-100 p-4 text-center dark:bg-gray-800">
          <p className="text-sm text-gray-600 dark:text-gray-400">Advertisement</p>
          {/* Ad placement code would go here */}
        </div>
      </div>

      <main className="mx-auto max-w-7xl p-4 pb-20">
        {children}
      </main>

      {/* Bottom Banner Ad */}
      <div className="mx-auto max-w-7xl p-4">
        <div className="rounded-lg bg-gray-100 p-4 text-center dark:bg-gray-800">
          <p className="text-sm text-gray-600 dark:text-gray-400">Advertisement</p>
          {/* Ad placement code would go here */}
        </div>
      </div>

      <footer className="border-t py-6 text-center text-sm text-gray-500 dark:border-gray-800 dark:text-gray-400">
        <div className="mx-auto max-w-7xl px-4">
          <p>© {new Date().getFullYear()} AI Phrase Detector. All rights reserved.</p>
        </div>
      </footer>
    </div>
  );
};