import React from 'react';

interface TextInputProps {
  value: string;
  onChange: (value: string) => void;
}

const TextInput: React.FC<TextInputProps> = ({ value, onChange }) => {
  return (
    <div className="relative h-96 group">
      <textarea
        value={value}
        onChange={(e) => onChange(e.target.value)}
        placeholder="Paste your text with unwanted formatting here..."
        className="w-full h-full p-4 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent resize-none font-mono text-sm transition-all duration-200 group-hover:border-blue-200"
      />
      <div className="absolute inset-0 bg-blue-50 bg-opacity-50 flex items-center justify-center pointer-events-none opacity-0 group-hover:opacity-100 transition-opacity duration-200 rounded-xl">
        {!value && (
          <div className="text-blue-500 bg-white px-4 py-2 rounded-full shadow-md">
            Click to start typing or paste your text
          </div>
        )}
      </div>
    </div>
  );
};

export default TextInput;