import React from 'react';
import { Sparkles as WandSparkles } from 'lucide-react';

const Header: React.FC = () => {
  return (
    <header className="bg-gradient-to-r from-blue-500 to-blue-600 shadow-lg">
      <div className="container mx-auto px-4 py-4 flex items-center justify-between">
        <div className="flex items-center space-x-2">
          <WandSparkles className="h-8 w-8 text-white animate-pulse" />
          <div>
            <h1 className="text-2xl font-bold text-white">CleanText AI</h1>
            <p className="text-blue-100 text-sm">Intelligent Text Sanitizer</p>
          </div>
        </div>
        <div className="bg-blue-400 bg-opacity-20 px-4 py-2 rounded-full text-white text-sm">
          Beta
        </div>
      </div>
    </header>
  );
};

export default Header;