import React from 'react';
import { Github, Heart } from 'lucide-react';

const Footer: React.FC = () => {
  return (
    <footer className="bg-white border-t border-gray-200 py-6 mt-12">
      <div className="container mx-auto px-4 flex flex-col md:flex-row items-center justify-between text-sm">
        <div className="flex items-center space-x-1 text-gray-600 mb-4 md:mb-0">
          <span>Made with</span>
          <Heart className="h-4 w-4 text-red-500 fill-current animate-pulse" />
          <span>by CleanText AI Team</span>
        </div>
        <div className="flex items-center space-x-6">
          <a href="#" className="text-gray-600 hover:text-blue-500 transition-colors">Terms</a>
          <a href="#" className="text-gray-600 hover:text-blue-500 transition-colors">Privacy</a>
          <a
            href="#"
            className="flex items-center space-x-2 text-gray-600 hover:text-blue-500 transition-colors bg-gray-50 px-4 py-2 rounded-full hover:bg-gray-100"
          >
            <Github className="h-4 w-4" />
            <span>GitHub</span>
          </a>
        </div>
      </div>
    </footer>
  );
};

export default Footer;